# 画面設計書 154-Cat ノード

## 概要

本ドキュメントは、OpenSearchのCat Nodes API（`GET /_cat/nodes`）エンドポイントに関する画面設計書である。クラスタノードの基本パフォーマンス統計をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタ内の各ノードのパフォーマンス統計（CPU使用率、ヒープ使用率、ディスク使用量、ロードアベレージ等）を一覧形式で確認するために使用される。ノードの健全性監視、リソース使用状況の確認、パフォーマンスボトルネックの特定に活用される。Cat APIの中でも最も情報量が多いAPIの一つである。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/nodes` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. ClusterStateRequestでノード一覧とクラスタマネージャ情報を取得する
2. NodesInfoRequestでJVM、OS、プロセス、HTTP情報を取得する
3. NodesStatsRequestでインデックス統計、JVM、OS、FS、プロセス、スクリプト統計を取得する
4. 3つのレスポンスを統合してテーブルを構築する

**画面遷移**：本APIはステートレスなREST APIである。ノード情報API（`GET /_nodes`）やノード統計API（`GET /_nodes/stats`）と関連する。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 主機能 | クラスタノードの基本パフォーマンス統計をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のノード情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/nodes` | ノード情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| bytes | enum | No | - | バイト値の表示単位（b/k/kb/m/mb/g/gb/t/tb/p/pb） |
| format | string | No | - | レスポンス形式（json, yamlなど） |
| full_id | boolean | No | false | ノードIDの完全表示 |
| local | boolean | No | false | **非推奨**: このパラメータはローカル動作しない |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

### デフォルト表示カラム

| カラム名 | エイリアス | 説明 |
|---------|-----------|------|
| ip | i | IPアドレス |
| heap.percent | hp | ヒープ使用率 |
| ram.percent | rp | RAM使用率 |
| cpu | cpu | CPU使用率 |
| load_1m | l | 1分間ロードアベレージ |
| load_5m | l | 5分間ロードアベレージ |
| load_15m | l | 15分間ロードアベレージ |
| node.role | r | ノードロール（略称） |
| node.roles | rs | ノードロール（全名称） |
| cluster_manager | cm | クラスタマネージャ（*=現在のマネージャ） |
| name | n | ノード名 |

### 非デフォルト表示カラム（一部抜粋）

| カラム名 | 説明 |
|---------|------|
| id | ノードID |
| pid | プロセスID |
| port | トランスポートポート |
| http_address | HTTPアドレス |
| version | OSバージョン |
| jdk | JDKバージョン |
| disk.total / disk.used / disk.avail | ディスク情報 |
| heap.current / heap.max | ヒープ情報 |
| ram.current / ram.max | RAM情報 |
| file_desc.current / file_desc.percent / file_desc.max | ファイルディスクリプタ情報 |
| segments.count / segments.memory | セグメント情報 |
| search.query_total / search.fetch_total | 検索統計 |
| indexing.index_total / indexing.delete_total | インデキシング統計 |
| merges.total / merges.total_time | マージ統計 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestNodesAction.doCatRequest()` が呼び出される。ClusterState -> NodesInfo -> NodesStatsの3段階の連鎖リクエストで情報を収集し、最終的にbuildTable()でテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | ノード情報取得成功時 | テーブル形式のノード情報 |
| 警告 | localパラメータ使用時 | 非推奨パラメータの使用警告 |

## 例外処理

- クラスタ状態取得失敗時：接続タイムアウトエラー
- ノード情報/統計が取得できないノード：該当項目がnullとして表示される

## 備考

- 3段階の連鎖リクエスト（ClusterState -> NodesInfo -> NodesStats）で構成される
- localパラメータは非推奨で、v7.6.0から警告が出力される
- ディスク使用率はFsInfoから計算される（diskUsed = diskTotal - diskAvailable）
- ノードロールは略称（d=data, m=master eligible等）と全名称の2カラムで表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | JvmInfo, ProcessInfo, HttpInfo等を保持 |
| 1-2 | NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | JvmStats, OsStats, FsInfo, NodeIndicesStats等を保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | Cat Nodes APIのエントリーポイント |

**主要処理フロー**:
1. **行97-98**: `routes()` で `GET /_cat/nodes` を登録
2. **行112-164**: `doCatRequest()` で3段階連鎖リクエスト発行
3. **行167-421**: `getTableWithHeader()` で約80カラムのテーブルヘッダー定義
4. **行423-657**: `buildTable()` でノードごとの統計情報をテーブル行に変換

### プログラム呼び出し階層図

```
RestNodesAction.doCatRequest() [行112]
    |
    +-- ClusterStateRequest (nodes=true) [行113-114]
    |
    +-- client.admin().cluster().state() [行124]
           |
           +-- NodesInfoRequest (JVM, OS, PROCESS, HTTP) [行127-135]
           |
           +-- client.admin().cluster().nodesInfo() [行136]
                  |
                  +-- NodesStatsRequest (indices, JVM, OS, FS, PROCESS, SCRIPT) [行139-150]
                  |
                  +-- client.admin().cluster().nodesStats() [行151]
                         |
                         +-- buildTable() [行423]
                                +-- getTableWithHeader() [行167]
```

### データフロー図

```
[入力]               [処理]                         [出力]

GET /_cat/nodes --> RestNodesAction                --> テーブル形式
                    |
                    v
               ClusterState (ノード一覧, CM情報)
                    |
                    v
               NodesInfo (JVM, OS, Process, HTTP)
                    |
                    v
               NodesStats (indices, JVM, OS, FS)
                    |
                    v
               buildTable() --> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | ソース | Cat Nodes APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | ソース | ノード情報データ構造 |
| NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ソース | ノード統計データ構造 |
| cat.nodes.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.nodes.json` | 設定 | REST API仕様定義 |
